import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcEndpointServiceConfigurationsRequest, DescribeVpcEndpointServiceConfigurationsResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommand, serializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommand, } from "../protocols/Aws_ec2";
var DescribeVpcEndpointServiceConfigurationsCommand = (function (_super) {
    __extends(DescribeVpcEndpointServiceConfigurationsCommand, _super);
    function DescribeVpcEndpointServiceConfigurationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcEndpointServiceConfigurationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcEndpointServiceConfigurationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcEndpointServiceConfigurationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcEndpointServiceConfigurationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcEndpointServiceConfigurationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommand(input, context);
    };
    DescribeVpcEndpointServiceConfigurationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommand(output, context);
    };
    return DescribeVpcEndpointServiceConfigurationsCommand;
}($Command));
export { DescribeVpcEndpointServiceConfigurationsCommand };
