import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcEndpointConnectionsRequest, DescribeVpcEndpointConnectionsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcEndpointConnectionsCommand, serializeAws_ec2DescribeVpcEndpointConnectionsCommand, } from "../protocols/Aws_ec2";
var DescribeVpcEndpointConnectionsCommand = (function (_super) {
    __extends(DescribeVpcEndpointConnectionsCommand, _super);
    function DescribeVpcEndpointConnectionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcEndpointConnectionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcEndpointConnectionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcEndpointConnectionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcEndpointConnectionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcEndpointConnectionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcEndpointConnectionsCommand(input, context);
    };
    DescribeVpcEndpointConnectionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcEndpointConnectionsCommand(output, context);
    };
    return DescribeVpcEndpointConnectionsCommand;
}($Command));
export { DescribeVpcEndpointConnectionsCommand };
