import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcClassicLinkDnsSupportRequest, DescribeVpcClassicLinkDnsSupportResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcClassicLinkDnsSupportCommand, serializeAws_ec2DescribeVpcClassicLinkDnsSupportCommand, } from "../protocols/Aws_ec2";
var DescribeVpcClassicLinkDnsSupportCommand = (function (_super) {
    __extends(DescribeVpcClassicLinkDnsSupportCommand, _super);
    function DescribeVpcClassicLinkDnsSupportCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcClassicLinkDnsSupportCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcClassicLinkDnsSupportCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcClassicLinkDnsSupportRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcClassicLinkDnsSupportResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcClassicLinkDnsSupportCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcClassicLinkDnsSupportCommand(input, context);
    };
    DescribeVpcClassicLinkDnsSupportCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcClassicLinkDnsSupportCommand(output, context);
    };
    return DescribeVpcClassicLinkDnsSupportCommand;
}($Command));
export { DescribeVpcClassicLinkDnsSupportCommand };
