import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVolumesModificationsRequest, DescribeVolumesModificationsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVolumesModificationsCommand, serializeAws_ec2DescribeVolumesModificationsCommand, } from "../protocols/Aws_ec2";
var DescribeVolumesModificationsCommand = (function (_super) {
    __extends(DescribeVolumesModificationsCommand, _super);
    function DescribeVolumesModificationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVolumesModificationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVolumesModificationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVolumesModificationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVolumesModificationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVolumesModificationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVolumesModificationsCommand(input, context);
    };
    DescribeVolumesModificationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVolumesModificationsCommand(output, context);
    };
    return DescribeVolumesModificationsCommand;
}($Command));
export { DescribeVolumesModificationsCommand };
