import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVolumesRequest, DescribeVolumesResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVolumesCommand, serializeAws_ec2DescribeVolumesCommand } from "../protocols/Aws_ec2";
var DescribeVolumesCommand = (function (_super) {
    __extends(DescribeVolumesCommand, _super);
    function DescribeVolumesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVolumesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVolumesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVolumesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVolumesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVolumesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVolumesCommand(input, context);
    };
    DescribeVolumesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVolumesCommand(output, context);
    };
    return DescribeVolumesCommand;
}($Command));
export { DescribeVolumesCommand };
