import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVolumeStatusRequest, DescribeVolumeStatusResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVolumeStatusCommand, serializeAws_ec2DescribeVolumeStatusCommand, } from "../protocols/Aws_ec2";
var DescribeVolumeStatusCommand = (function (_super) {
    __extends(DescribeVolumeStatusCommand, _super);
    function DescribeVolumeStatusCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVolumeStatusCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVolumeStatusCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVolumeStatusRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVolumeStatusResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVolumeStatusCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVolumeStatusCommand(input, context);
    };
    DescribeVolumeStatusCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVolumeStatusCommand(output, context);
    };
    return DescribeVolumeStatusCommand;
}($Command));
export { DescribeVolumeStatusCommand };
