import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewayRouteTablesRequest, DescribeTransitGatewayRouteTablesResult } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewayRouteTablesCommand, serializeAws_ec2DescribeTransitGatewayRouteTablesCommand, } from "../protocols/Aws_ec2";
var DescribeTransitGatewayRouteTablesCommand = (function (_super) {
    __extends(DescribeTransitGatewayRouteTablesCommand, _super);
    function DescribeTransitGatewayRouteTablesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTransitGatewayRouteTablesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTransitGatewayRouteTablesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTransitGatewayRouteTablesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewayRouteTablesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTransitGatewayRouteTablesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTransitGatewayRouteTablesCommand(input, context);
    };
    DescribeTransitGatewayRouteTablesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTransitGatewayRouteTablesCommand(output, context);
    };
    return DescribeTransitGatewayRouteTablesCommand;
}($Command));
export { DescribeTransitGatewayRouteTablesCommand };
