import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewayMulticastDomainsRequest, DescribeTransitGatewayMulticastDomainsResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewayMulticastDomainsCommand, serializeAws_ec2DescribeTransitGatewayMulticastDomainsCommand, } from "../protocols/Aws_ec2";
var DescribeTransitGatewayMulticastDomainsCommand = (function (_super) {
    __extends(DescribeTransitGatewayMulticastDomainsCommand, _super);
    function DescribeTransitGatewayMulticastDomainsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTransitGatewayMulticastDomainsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTransitGatewayMulticastDomainsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTransitGatewayMulticastDomainsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewayMulticastDomainsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTransitGatewayMulticastDomainsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTransitGatewayMulticastDomainsCommand(input, context);
    };
    DescribeTransitGatewayMulticastDomainsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTransitGatewayMulticastDomainsCommand(output, context);
    };
    return DescribeTransitGatewayMulticastDomainsCommand;
}($Command));
export { DescribeTransitGatewayMulticastDomainsCommand };
