import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTagsRequest, DescribeTagsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeTagsCommand, serializeAws_ec2DescribeTagsCommand } from "../protocols/Aws_ec2";
var DescribeTagsCommand = (function (_super) {
    __extends(DescribeTagsCommand, _super);
    function DescribeTagsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTagsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTagsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTagsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTagsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTagsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTagsCommand(input, context);
    };
    DescribeTagsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTagsCommand(output, context);
    };
    return DescribeTagsCommand;
}($Command));
export { DescribeTagsCommand };
