import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeScheduledInstanceAvailabilityRequest, DescribeScheduledInstanceAvailabilityResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeScheduledInstanceAvailabilityCommand, serializeAws_ec2DescribeScheduledInstanceAvailabilityCommand, } from "../protocols/Aws_ec2";
var DescribeScheduledInstanceAvailabilityCommand = (function (_super) {
    __extends(DescribeScheduledInstanceAvailabilityCommand, _super);
    function DescribeScheduledInstanceAvailabilityCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeScheduledInstanceAvailabilityCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeScheduledInstanceAvailabilityCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeScheduledInstanceAvailabilityRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeScheduledInstanceAvailabilityResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeScheduledInstanceAvailabilityCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeScheduledInstanceAvailabilityCommand(input, context);
    };
    DescribeScheduledInstanceAvailabilityCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeScheduledInstanceAvailabilityCommand(output, context);
    };
    return DescribeScheduledInstanceAvailabilityCommand;
}($Command));
export { DescribeScheduledInstanceAvailabilityCommand };
