import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribePublicIpv4PoolsRequest, DescribePublicIpv4PoolsResult } from "../models/models_3";
import { deserializeAws_ec2DescribePublicIpv4PoolsCommand, serializeAws_ec2DescribePublicIpv4PoolsCommand, } from "../protocols/Aws_ec2";
var DescribePublicIpv4PoolsCommand = (function (_super) {
    __extends(DescribePublicIpv4PoolsCommand, _super);
    function DescribePublicIpv4PoolsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribePublicIpv4PoolsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribePublicIpv4PoolsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribePublicIpv4PoolsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribePublicIpv4PoolsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribePublicIpv4PoolsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribePublicIpv4PoolsCommand(input, context);
    };
    DescribePublicIpv4PoolsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribePublicIpv4PoolsCommand(output, context);
    };
    return DescribePublicIpv4PoolsCommand;
}($Command));
export { DescribePublicIpv4PoolsCommand };
