import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNetworkInterfacePermissionsRequest, DescribeNetworkInterfacePermissionsResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeNetworkInterfacePermissionsCommand, serializeAws_ec2DescribeNetworkInterfacePermissionsCommand, } from "../protocols/Aws_ec2";
var DescribeNetworkInterfacePermissionsCommand = (function (_super) {
    __extends(DescribeNetworkInterfacePermissionsCommand, _super);
    function DescribeNetworkInterfacePermissionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNetworkInterfacePermissionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNetworkInterfacePermissionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNetworkInterfacePermissionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNetworkInterfacePermissionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNetworkInterfacePermissionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNetworkInterfacePermissionsCommand(input, context);
    };
    DescribeNetworkInterfacePermissionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNetworkInterfacePermissionsCommand(output, context);
    };
    return DescribeNetworkInterfacePermissionsCommand;
}($Command));
export { DescribeNetworkInterfacePermissionsCommand };
