import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNetworkInterfaceAttributeRequest, DescribeNetworkInterfaceAttributeResult } from "../models/models_3";
import { deserializeAws_ec2DescribeNetworkInterfaceAttributeCommand, serializeAws_ec2DescribeNetworkInterfaceAttributeCommand, } from "../protocols/Aws_ec2";
var DescribeNetworkInterfaceAttributeCommand = (function (_super) {
    __extends(DescribeNetworkInterfaceAttributeCommand, _super);
    function DescribeNetworkInterfaceAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNetworkInterfaceAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNetworkInterfaceAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNetworkInterfaceAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNetworkInterfaceAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNetworkInterfaceAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNetworkInterfaceAttributeCommand(input, context);
    };
    DescribeNetworkInterfaceAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNetworkInterfaceAttributeCommand(output, context);
    };
    return DescribeNetworkInterfaceAttributeCommand;
}($Command));
export { DescribeNetworkInterfaceAttributeCommand };
