import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNetworkInsightsAccessScopesRequest, DescribeNetworkInsightsAccessScopesResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeNetworkInsightsAccessScopesCommand, serializeAws_ec2DescribeNetworkInsightsAccessScopesCommand, } from "../protocols/Aws_ec2";
var DescribeNetworkInsightsAccessScopesCommand = (function (_super) {
    __extends(DescribeNetworkInsightsAccessScopesCommand, _super);
    function DescribeNetworkInsightsAccessScopesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNetworkInsightsAccessScopesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNetworkInsightsAccessScopesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNetworkInsightsAccessScopesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNetworkInsightsAccessScopesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNetworkInsightsAccessScopesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNetworkInsightsAccessScopesCommand(input, context);
    };
    DescribeNetworkInsightsAccessScopesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNetworkInsightsAccessScopesCommand(output, context);
    };
    return DescribeNetworkInsightsAccessScopesCommand;
}($Command));
export { DescribeNetworkInsightsAccessScopesCommand };
