import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNetworkInsightsAccessScopeAnalysesRequest, DescribeNetworkInsightsAccessScopeAnalysesResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommand, serializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommand, } from "../protocols/Aws_ec2";
var DescribeNetworkInsightsAccessScopeAnalysesCommand = (function (_super) {
    __extends(DescribeNetworkInsightsAccessScopeAnalysesCommand, _super);
    function DescribeNetworkInsightsAccessScopeAnalysesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNetworkInsightsAccessScopeAnalysesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNetworkInsightsAccessScopeAnalysesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNetworkInsightsAccessScopeAnalysesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNetworkInsightsAccessScopeAnalysesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNetworkInsightsAccessScopeAnalysesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommand(input, context);
    };
    DescribeNetworkInsightsAccessScopeAnalysesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommand(output, context);
    };
    return DescribeNetworkInsightsAccessScopeAnalysesCommand;
}($Command));
export { DescribeNetworkInsightsAccessScopeAnalysesCommand };
