import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLocalGatewayVirtualInterfacesRequest, DescribeLocalGatewayVirtualInterfacesResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommand, serializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommand, } from "../protocols/Aws_ec2";
var DescribeLocalGatewayVirtualInterfacesCommand = (function (_super) {
    __extends(DescribeLocalGatewayVirtualInterfacesCommand, _super);
    function DescribeLocalGatewayVirtualInterfacesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLocalGatewayVirtualInterfacesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLocalGatewayVirtualInterfacesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLocalGatewayVirtualInterfacesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLocalGatewayVirtualInterfacesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLocalGatewayVirtualInterfacesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommand(input, context);
    };
    DescribeLocalGatewayVirtualInterfacesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommand(output, context);
    };
    return DescribeLocalGatewayVirtualInterfacesCommand;
}($Command));
export { DescribeLocalGatewayVirtualInterfacesCommand };
