import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLocalGatewayVirtualInterfaceGroupsRequest, DescribeLocalGatewayVirtualInterfaceGroupsResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommand, serializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommand, } from "../protocols/Aws_ec2";
var DescribeLocalGatewayVirtualInterfaceGroupsCommand = (function (_super) {
    __extends(DescribeLocalGatewayVirtualInterfaceGroupsCommand, _super);
    function DescribeLocalGatewayVirtualInterfaceGroupsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLocalGatewayVirtualInterfaceGroupsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLocalGatewayVirtualInterfaceGroupsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLocalGatewayVirtualInterfaceGroupsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLocalGatewayVirtualInterfaceGroupsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLocalGatewayVirtualInterfaceGroupsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommand(input, context);
    };
    DescribeLocalGatewayVirtualInterfaceGroupsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommand(output, context);
    };
    return DescribeLocalGatewayVirtualInterfaceGroupsCommand;
}($Command));
export { DescribeLocalGatewayVirtualInterfaceGroupsCommand };
