import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand, serializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand, } from "../protocols/Aws_ec2";
var DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand = (function (_super) {
    __extends(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand, _super);
    function DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand(input, context);
    };
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand(output, context);
    };
    return DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand;
}($Command));
export { DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand };
