import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeKeyPairsRequest, DescribeKeyPairsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeKeyPairsCommand, serializeAws_ec2DescribeKeyPairsCommand, } from "../protocols/Aws_ec2";
var DescribeKeyPairsCommand = (function (_super) {
    __extends(DescribeKeyPairsCommand, _super);
    function DescribeKeyPairsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeKeyPairsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeKeyPairsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeKeyPairsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeKeyPairsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeKeyPairsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeKeyPairsCommand(input, context);
    };
    DescribeKeyPairsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeKeyPairsCommand(output, context);
    };
    return DescribeKeyPairsCommand;
}($Command));
export { DescribeKeyPairsCommand };
