import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIpamsRequest, DescribeIpamsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeIpamsCommand, serializeAws_ec2DescribeIpamsCommand } from "../protocols/Aws_ec2";
var DescribeIpamsCommand = (function (_super) {
    __extends(DescribeIpamsCommand, _super);
    function DescribeIpamsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeIpamsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeIpamsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeIpamsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeIpamsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeIpamsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeIpamsCommand(input, context);
    };
    DescribeIpamsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeIpamsCommand(output, context);
    };
    return DescribeIpamsCommand;
}($Command));
export { DescribeIpamsCommand };
