import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIpamPoolsRequest, DescribeIpamPoolsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeIpamPoolsCommand, serializeAws_ec2DescribeIpamPoolsCommand, } from "../protocols/Aws_ec2";
var DescribeIpamPoolsCommand = (function (_super) {
    __extends(DescribeIpamPoolsCommand, _super);
    function DescribeIpamPoolsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeIpamPoolsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeIpamPoolsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeIpamPoolsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeIpamPoolsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeIpamPoolsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeIpamPoolsCommand(input, context);
    };
    DescribeIpamPoolsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeIpamPoolsCommand(output, context);
    };
    return DescribeIpamPoolsCommand;
}($Command));
export { DescribeIpamPoolsCommand };
