import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInternetGatewaysRequest, DescribeInternetGatewaysResult } from "../models/models_3";
import { deserializeAws_ec2DescribeInternetGatewaysCommand, serializeAws_ec2DescribeInternetGatewaysCommand, } from "../protocols/Aws_ec2";
var DescribeInternetGatewaysCommand = (function (_super) {
    __extends(DescribeInternetGatewaysCommand, _super);
    function DescribeInternetGatewaysCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeInternetGatewaysCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeInternetGatewaysCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeInternetGatewaysRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeInternetGatewaysResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeInternetGatewaysCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeInternetGatewaysCommand(input, context);
    };
    DescribeInternetGatewaysCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeInternetGatewaysCommand(output, context);
    };
    return DescribeInternetGatewaysCommand;
}($Command));
export { DescribeInternetGatewaysCommand };
