import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInstanceStatusRequest, DescribeInstanceStatusResult } from "../models/models_3";
import { deserializeAws_ec2DescribeInstanceStatusCommand, serializeAws_ec2DescribeInstanceStatusCommand, } from "../protocols/Aws_ec2";
var DescribeInstanceStatusCommand = (function (_super) {
    __extends(DescribeInstanceStatusCommand, _super);
    function DescribeInstanceStatusCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeInstanceStatusCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeInstanceStatusCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeInstanceStatusRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeInstanceStatusResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeInstanceStatusCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeInstanceStatusCommand(input, context);
    };
    DescribeInstanceStatusCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeInstanceStatusCommand(output, context);
    };
    return DescribeInstanceStatusCommand;
}($Command));
export { DescribeInstanceStatusCommand };
