import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeImportImageTasksRequest, DescribeImportImageTasksResult } from "../models/models_3";
import { deserializeAws_ec2DescribeImportImageTasksCommand, serializeAws_ec2DescribeImportImageTasksCommand, } from "../protocols/Aws_ec2";
var DescribeImportImageTasksCommand = (function (_super) {
    __extends(DescribeImportImageTasksCommand, _super);
    function DescribeImportImageTasksCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeImportImageTasksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeImportImageTasksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeImportImageTasksRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeImportImageTasksResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeImportImageTasksCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeImportImageTasksCommand(input, context);
    };
    DescribeImportImageTasksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeImportImageTasksCommand(output, context);
    };
    return DescribeImportImageTasksCommand;
}($Command));
export { DescribeImportImageTasksCommand };
