import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeImagesRequest, DescribeImagesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeImagesCommand, serializeAws_ec2DescribeImagesCommand } from "../protocols/Aws_ec2";
var DescribeImagesCommand = (function (_super) {
    __extends(DescribeImagesCommand, _super);
    function DescribeImagesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeImagesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeImagesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeImagesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeImagesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeImagesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeImagesCommand(input, context);
    };
    DescribeImagesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeImagesCommand(output, context);
    };
    return DescribeImagesCommand;
}($Command));
export { DescribeImagesCommand };
