import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIdFormatRequest, DescribeIdFormatResult } from "../models/models_3";
import { deserializeAws_ec2DescribeIdFormatCommand, serializeAws_ec2DescribeIdFormatCommand, } from "../protocols/Aws_ec2";
var DescribeIdFormatCommand = (function (_super) {
    __extends(DescribeIdFormatCommand, _super);
    function DescribeIdFormatCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeIdFormatCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeIdFormatCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeIdFormatRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeIdFormatResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeIdFormatCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeIdFormatCommand(input, context);
    };
    DescribeIdFormatCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeIdFormatCommand(output, context);
    };
    return DescribeIdFormatCommand;
}($Command));
export { DescribeIdFormatCommand };
