import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeFlowLogsRequest, DescribeFlowLogsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeFlowLogsCommand, serializeAws_ec2DescribeFlowLogsCommand, } from "../protocols/Aws_ec2";
var DescribeFlowLogsCommand = (function (_super) {
    __extends(DescribeFlowLogsCommand, _super);
    function DescribeFlowLogsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeFlowLogsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeFlowLogsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeFlowLogsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeFlowLogsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeFlowLogsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeFlowLogsCommand(input, context);
    };
    DescribeFlowLogsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeFlowLogsCommand(output, context);
    };
    return DescribeFlowLogsCommand;
}($Command));
export { DescribeFlowLogsCommand };
