import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeFleetInstancesRequest, DescribeFleetInstancesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeFleetInstancesCommand, serializeAws_ec2DescribeFleetInstancesCommand, } from "../protocols/Aws_ec2";
var DescribeFleetInstancesCommand = (function (_super) {
    __extends(DescribeFleetInstancesCommand, _super);
    function DescribeFleetInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeFleetInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeFleetInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeFleetInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeFleetInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeFleetInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeFleetInstancesCommand(input, context);
    };
    DescribeFleetInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeFleetInstancesCommand(output, context);
    };
    return DescribeFleetInstancesCommand;
}($Command));
export { DescribeFleetInstancesCommand };
