import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeDhcpOptionsRequest, DescribeDhcpOptionsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeDhcpOptionsCommand, serializeAws_ec2DescribeDhcpOptionsCommand, } from "../protocols/Aws_ec2";
var DescribeDhcpOptionsCommand = (function (_super) {
    __extends(DescribeDhcpOptionsCommand, _super);
    function DescribeDhcpOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeDhcpOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeDhcpOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeDhcpOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeDhcpOptionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeDhcpOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeDhcpOptionsCommand(input, context);
    };
    DescribeDhcpOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeDhcpOptionsCommand(output, context);
    };
    return DescribeDhcpOptionsCommand;
}($Command));
export { DescribeDhcpOptionsCommand };
