import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeConversionTasksRequest } from "../models/models_2";
import { DescribeConversionTasksResult } from "../models/models_3";
import { deserializeAws_ec2DescribeConversionTasksCommand, serializeAws_ec2DescribeConversionTasksCommand, } from "../protocols/Aws_ec2";
var DescribeConversionTasksCommand = (function (_super) {
    __extends(DescribeConversionTasksCommand, _super);
    function DescribeConversionTasksCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeConversionTasksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeConversionTasksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeConversionTasksRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeConversionTasksResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeConversionTasksCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeConversionTasksCommand(input, context);
    };
    DescribeConversionTasksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeConversionTasksCommand(output, context);
    };
    return DescribeConversionTasksCommand;
}($Command));
export { DescribeConversionTasksCommand };
