import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeClientVpnTargetNetworksRequest, DescribeClientVpnTargetNetworksResult } from "../models/models_2";
import { deserializeAws_ec2DescribeClientVpnTargetNetworksCommand, serializeAws_ec2DescribeClientVpnTargetNetworksCommand, } from "../protocols/Aws_ec2";
var DescribeClientVpnTargetNetworksCommand = (function (_super) {
    __extends(DescribeClientVpnTargetNetworksCommand, _super);
    function DescribeClientVpnTargetNetworksCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeClientVpnTargetNetworksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeClientVpnTargetNetworksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeClientVpnTargetNetworksRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeClientVpnTargetNetworksResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeClientVpnTargetNetworksCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeClientVpnTargetNetworksCommand(input, context);
    };
    DescribeClientVpnTargetNetworksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeClientVpnTargetNetworksCommand(output, context);
    };
    return DescribeClientVpnTargetNetworksCommand;
}($Command));
export { DescribeClientVpnTargetNetworksCommand };
