import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeClientVpnEndpointsRequest, DescribeClientVpnEndpointsResult } from "../models/models_2";
import { deserializeAws_ec2DescribeClientVpnEndpointsCommand, serializeAws_ec2DescribeClientVpnEndpointsCommand, } from "../protocols/Aws_ec2";
var DescribeClientVpnEndpointsCommand = (function (_super) {
    __extends(DescribeClientVpnEndpointsCommand, _super);
    function DescribeClientVpnEndpointsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeClientVpnEndpointsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeClientVpnEndpointsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeClientVpnEndpointsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeClientVpnEndpointsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeClientVpnEndpointsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeClientVpnEndpointsCommand(input, context);
    };
    DescribeClientVpnEndpointsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeClientVpnEndpointsCommand(output, context);
    };
    return DescribeClientVpnEndpointsCommand;
}($Command));
export { DescribeClientVpnEndpointsCommand };
