import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeClientVpnAuthorizationRulesRequest, DescribeClientVpnAuthorizationRulesResult, } from "../models/models_2";
import { deserializeAws_ec2DescribeClientVpnAuthorizationRulesCommand, serializeAws_ec2DescribeClientVpnAuthorizationRulesCommand, } from "../protocols/Aws_ec2";
var DescribeClientVpnAuthorizationRulesCommand = (function (_super) {
    __extends(DescribeClientVpnAuthorizationRulesCommand, _super);
    function DescribeClientVpnAuthorizationRulesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeClientVpnAuthorizationRulesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeClientVpnAuthorizationRulesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeClientVpnAuthorizationRulesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeClientVpnAuthorizationRulesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeClientVpnAuthorizationRulesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeClientVpnAuthorizationRulesCommand(input, context);
    };
    DescribeClientVpnAuthorizationRulesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeClientVpnAuthorizationRulesCommand(output, context);
    };
    return DescribeClientVpnAuthorizationRulesCommand;
}($Command));
export { DescribeClientVpnAuthorizationRulesCommand };
