import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeClassicLinkInstancesRequest, DescribeClassicLinkInstancesResult } from "../models/models_2";
import { deserializeAws_ec2DescribeClassicLinkInstancesCommand, serializeAws_ec2DescribeClassicLinkInstancesCommand, } from "../protocols/Aws_ec2";
var DescribeClassicLinkInstancesCommand = (function (_super) {
    __extends(DescribeClassicLinkInstancesCommand, _super);
    function DescribeClassicLinkInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeClassicLinkInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeClassicLinkInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeClassicLinkInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeClassicLinkInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeClassicLinkInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeClassicLinkInstancesCommand(input, context);
    };
    DescribeClassicLinkInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeClassicLinkInstancesCommand(output, context);
    };
    return DescribeClassicLinkInstancesCommand;
}($Command));
export { DescribeClassicLinkInstancesCommand };
