import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeCapacityReservationFleetsRequest, DescribeCapacityReservationFleetsResult } from "../models/models_2";
import { deserializeAws_ec2DescribeCapacityReservationFleetsCommand, serializeAws_ec2DescribeCapacityReservationFleetsCommand, } from "../protocols/Aws_ec2";
var DescribeCapacityReservationFleetsCommand = (function (_super) {
    __extends(DescribeCapacityReservationFleetsCommand, _super);
    function DescribeCapacityReservationFleetsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeCapacityReservationFleetsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeCapacityReservationFleetsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeCapacityReservationFleetsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeCapacityReservationFleetsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeCapacityReservationFleetsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeCapacityReservationFleetsCommand(input, context);
    };
    DescribeCapacityReservationFleetsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeCapacityReservationFleetsCommand(output, context);
    };
    return DescribeCapacityReservationFleetsCommand;
}($Command));
export { DescribeCapacityReservationFleetsCommand };
