import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeprovisionIpamPoolCidrRequest, DeprovisionIpamPoolCidrResult } from "../models/models_2";
import { deserializeAws_ec2DeprovisionIpamPoolCidrCommand, serializeAws_ec2DeprovisionIpamPoolCidrCommand, } from "../protocols/Aws_ec2";
var DeprovisionIpamPoolCidrCommand = (function (_super) {
    __extends(DeprovisionIpamPoolCidrCommand, _super);
    function DeprovisionIpamPoolCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeprovisionIpamPoolCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeprovisionIpamPoolCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeprovisionIpamPoolCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeprovisionIpamPoolCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeprovisionIpamPoolCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeprovisionIpamPoolCidrCommand(input, context);
    };
    DeprovisionIpamPoolCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeprovisionIpamPoolCidrCommand(output, context);
    };
    return DeprovisionIpamPoolCidrCommand;
}($Command));
export { DeprovisionIpamPoolCidrCommand };
