import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVpnGatewayRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteVpnGatewayCommand, serializeAws_ec2DeleteVpnGatewayCommand, } from "../protocols/Aws_ec2";
var DeleteVpnGatewayCommand = (function (_super) {
    __extends(DeleteVpnGatewayCommand, _super);
    function DeleteVpnGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVpnGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVpnGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVpnGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVpnGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVpnGatewayCommand(input, context);
    };
    DeleteVpnGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVpnGatewayCommand(output, context);
    };
    return DeleteVpnGatewayCommand;
}($Command));
export { DeleteVpnGatewayCommand };
