import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVpnConnectionRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteVpnConnectionCommand, serializeAws_ec2DeleteVpnConnectionCommand, } from "../protocols/Aws_ec2";
var DeleteVpnConnectionCommand = (function (_super) {
    __extends(DeleteVpnConnectionCommand, _super);
    function DeleteVpnConnectionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVpnConnectionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVpnConnectionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVpnConnectionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVpnConnectionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVpnConnectionCommand(input, context);
    };
    DeleteVpnConnectionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVpnConnectionCommand(output, context);
    };
    return DeleteVpnConnectionCommand;
}($Command));
export { DeleteVpnConnectionCommand };
