import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVpcEndpointsRequest, DeleteVpcEndpointsResult } from "../models/models_2";
import { deserializeAws_ec2DeleteVpcEndpointsCommand, serializeAws_ec2DeleteVpcEndpointsCommand, } from "../protocols/Aws_ec2";
var DeleteVpcEndpointsCommand = (function (_super) {
    __extends(DeleteVpcEndpointsCommand, _super);
    function DeleteVpcEndpointsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVpcEndpointsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVpcEndpointsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVpcEndpointsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteVpcEndpointsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVpcEndpointsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVpcEndpointsCommand(input, context);
    };
    DeleteVpcEndpointsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVpcEndpointsCommand(output, context);
    };
    return DeleteVpcEndpointsCommand;
}($Command));
export { DeleteVpcEndpointsCommand };
