import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVolumeRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteVolumeCommand, serializeAws_ec2DeleteVolumeCommand } from "../protocols/Aws_ec2";
var DeleteVolumeCommand = (function (_super) {
    __extends(DeleteVolumeCommand, _super);
    function DeleteVolumeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVolumeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVolumeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVolumeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVolumeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVolumeCommand(input, context);
    };
    DeleteVolumeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVolumeCommand(output, context);
    };
    return DeleteVolumeCommand;
}($Command));
export { DeleteVolumeCommand };
