import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayRouteRequest, DeleteTransitGatewayRouteResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayRouteCommand, serializeAws_ec2DeleteTransitGatewayRouteCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayRouteCommand = (function (_super) {
    __extends(DeleteTransitGatewayRouteCommand, _super);
    function DeleteTransitGatewayRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayRouteCommand(input, context);
    };
    DeleteTransitGatewayRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayRouteCommand(output, context);
    };
    return DeleteTransitGatewayRouteCommand;
}($Command));
export { DeleteTransitGatewayRouteCommand };
