import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTrafficMirrorSessionRequest, DeleteTrafficMirrorSessionResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTrafficMirrorSessionCommand, serializeAws_ec2DeleteTrafficMirrorSessionCommand, } from "../protocols/Aws_ec2";
var DeleteTrafficMirrorSessionCommand = (function (_super) {
    __extends(DeleteTrafficMirrorSessionCommand, _super);
    function DeleteTrafficMirrorSessionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTrafficMirrorSessionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTrafficMirrorSessionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTrafficMirrorSessionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTrafficMirrorSessionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTrafficMirrorSessionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTrafficMirrorSessionCommand(input, context);
    };
    DeleteTrafficMirrorSessionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTrafficMirrorSessionCommand(output, context);
    };
    return DeleteTrafficMirrorSessionCommand;
}($Command));
export { DeleteTrafficMirrorSessionCommand };
