import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteSubnetRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteSubnetCommand, serializeAws_ec2DeleteSubnetCommand } from "../protocols/Aws_ec2";
var DeleteSubnetCommand = (function (_super) {
    __extends(DeleteSubnetCommand, _super);
    function DeleteSubnetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteSubnetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteSubnetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteSubnetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteSubnetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteSubnetCommand(input, context);
    };
    DeleteSubnetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteSubnetCommand(output, context);
    };
    return DeleteSubnetCommand;
}($Command));
export { DeleteSubnetCommand };
