import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteSpotDatafeedSubscriptionRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteSpotDatafeedSubscriptionCommand, serializeAws_ec2DeleteSpotDatafeedSubscriptionCommand, } from "../protocols/Aws_ec2";
var DeleteSpotDatafeedSubscriptionCommand = (function (_super) {
    __extends(DeleteSpotDatafeedSubscriptionCommand, _super);
    function DeleteSpotDatafeedSubscriptionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteSpotDatafeedSubscriptionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteSpotDatafeedSubscriptionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteSpotDatafeedSubscriptionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteSpotDatafeedSubscriptionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteSpotDatafeedSubscriptionCommand(input, context);
    };
    DeleteSpotDatafeedSubscriptionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteSpotDatafeedSubscriptionCommand(output, context);
    };
    return DeleteSpotDatafeedSubscriptionCommand;
}($Command));
export { DeleteSpotDatafeedSubscriptionCommand };
