import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteNetworkInterfacePermissionRequest, DeleteNetworkInterfacePermissionResult } from "../models/models_2";
import { deserializeAws_ec2DeleteNetworkInterfacePermissionCommand, serializeAws_ec2DeleteNetworkInterfacePermissionCommand, } from "../protocols/Aws_ec2";
var DeleteNetworkInterfacePermissionCommand = (function (_super) {
    __extends(DeleteNetworkInterfacePermissionCommand, _super);
    function DeleteNetworkInterfacePermissionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteNetworkInterfacePermissionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteNetworkInterfacePermissionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteNetworkInterfacePermissionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteNetworkInterfacePermissionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteNetworkInterfacePermissionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteNetworkInterfacePermissionCommand(input, context);
    };
    DeleteNetworkInterfacePermissionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteNetworkInterfacePermissionCommand(output, context);
    };
    return DeleteNetworkInterfacePermissionCommand;
}($Command));
export { DeleteNetworkInterfacePermissionCommand };
