import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteNetworkInsightsPathRequest, DeleteNetworkInsightsPathResult } from "../models/models_2";
import { deserializeAws_ec2DeleteNetworkInsightsPathCommand, serializeAws_ec2DeleteNetworkInsightsPathCommand, } from "../protocols/Aws_ec2";
var DeleteNetworkInsightsPathCommand = (function (_super) {
    __extends(DeleteNetworkInsightsPathCommand, _super);
    function DeleteNetworkInsightsPathCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteNetworkInsightsPathCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteNetworkInsightsPathCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteNetworkInsightsPathRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteNetworkInsightsPathResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteNetworkInsightsPathCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteNetworkInsightsPathCommand(input, context);
    };
    DeleteNetworkInsightsPathCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteNetworkInsightsPathCommand(output, context);
    };
    return DeleteNetworkInsightsPathCommand;
}($Command));
export { DeleteNetworkInsightsPathCommand };
