import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteNetworkInsightsAnalysisRequest, DeleteNetworkInsightsAnalysisResult } from "../models/models_2";
import { deserializeAws_ec2DeleteNetworkInsightsAnalysisCommand, serializeAws_ec2DeleteNetworkInsightsAnalysisCommand, } from "../protocols/Aws_ec2";
var DeleteNetworkInsightsAnalysisCommand = (function (_super) {
    __extends(DeleteNetworkInsightsAnalysisCommand, _super);
    function DeleteNetworkInsightsAnalysisCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteNetworkInsightsAnalysisCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteNetworkInsightsAnalysisCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteNetworkInsightsAnalysisRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteNetworkInsightsAnalysisResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteNetworkInsightsAnalysisCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteNetworkInsightsAnalysisCommand(input, context);
    };
    DeleteNetworkInsightsAnalysisCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteNetworkInsightsAnalysisCommand(output, context);
    };
    return DeleteNetworkInsightsAnalysisCommand;
}($Command));
export { DeleteNetworkInsightsAnalysisCommand };
