import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteNetworkAclEntryRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteNetworkAclEntryCommand, serializeAws_ec2DeleteNetworkAclEntryCommand, } from "../protocols/Aws_ec2";
var DeleteNetworkAclEntryCommand = (function (_super) {
    __extends(DeleteNetworkAclEntryCommand, _super);
    function DeleteNetworkAclEntryCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteNetworkAclEntryCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteNetworkAclEntryCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteNetworkAclEntryRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteNetworkAclEntryCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteNetworkAclEntryCommand(input, context);
    };
    DeleteNetworkAclEntryCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteNetworkAclEntryCommand(output, context);
    };
    return DeleteNetworkAclEntryCommand;
}($Command));
export { DeleteNetworkAclEntryCommand };
