import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteIpamScopeRequest, DeleteIpamScopeResult } from "../models/models_2";
import { deserializeAws_ec2DeleteIpamScopeCommand, serializeAws_ec2DeleteIpamScopeCommand } from "../protocols/Aws_ec2";
var DeleteIpamScopeCommand = (function (_super) {
    __extends(DeleteIpamScopeCommand, _super);
    function DeleteIpamScopeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteIpamScopeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteIpamScopeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteIpamScopeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteIpamScopeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteIpamScopeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteIpamScopeCommand(input, context);
    };
    DeleteIpamScopeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteIpamScopeCommand(output, context);
    };
    return DeleteIpamScopeCommand;
}($Command));
export { DeleteIpamScopeCommand };
