import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteIpamPoolRequest, DeleteIpamPoolResult } from "../models/models_2";
import { deserializeAws_ec2DeleteIpamPoolCommand, serializeAws_ec2DeleteIpamPoolCommand } from "../protocols/Aws_ec2";
var DeleteIpamPoolCommand = (function (_super) {
    __extends(DeleteIpamPoolCommand, _super);
    function DeleteIpamPoolCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteIpamPoolCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteIpamPoolCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteIpamPoolRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteIpamPoolResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteIpamPoolCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteIpamPoolCommand(input, context);
    };
    DeleteIpamPoolCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteIpamPoolCommand(output, context);
    };
    return DeleteIpamPoolCommand;
}($Command));
export { DeleteIpamPoolCommand };
